﻿$IntuneDeployScriptDir = "C:\ProgramData\IntuneDeployedScripts"
if(!(Test-Path $IntuneDeployScriptDir)){
    New-Item -ItemType Directory -Path $IntuneDeployScriptDir -Force
}

Function Log-Message{
    param (
        [string]$message,
        [string]$Logfile = "C:\ProgramData\IntuneDeployedScripts\DTBC-0078_STIG.log"   
    )
    $Timestamp = Get-Date -Format "yyyy-MM-dd HH:mm:ss"
    "$Timestamp - $message" | Out-File -FilePath $Logfile -Append
}

$GoogleChromeRegPath = "HKLM:\Software\Policies\Google\Chrome"
$HelpMeWriteSettingsKey = "HelpMeWriteSettings"
$HelpMeWriteSettingsValue = 2
if(!(Test-Path $GoogleChromeRegPath)){
    Log-Message -message "$GoogleChromeRegPath registry path not found"
    New-Item -Path $GoogleChromeRegPath -Force | Out-Null
    Log-Message -message "$GoogleChromeRegPath registry path created"
    New-ItemProperty -Path $GoogleChromeRegPath -Name $HelpMeWriteSettingsKey -Value $HelpMeWriteSettingsValue -PropertyType DWORD -Force | Out-Null
    Log-Message -message "$HelpMeWriteSettingsKey registry key created value $HelpMeWriteSettingsValue "
} else {
    Log-Message -message "Checking value of $HelpMeWriteSettingsKey registry key expecting $HelpMeWriteSettingsValue"
    Try {
        $HelpMeWriteSettingsCheck = Get-ItemPropertyValue -Path $GoogleChromeRegPath -Name $HelpMeWriteSettingsKey
        if($HelpMeWriteSettingsCheck -ne $HelpMeWriteSettingsValue){
            Log-Message -message "$HelpMeWriteSettingsKey configured incorrect value: $HelpMeWriteSettingsCheck"
            New-ItemProperty -Path $GoogleChromeRegPath -Name $HelpMeWriteSettingsKey -Value $HelpMeWriteSettingsValue -PropertyType DWORD -Force | Out-Null
            Log-Message -message "Set $HelpMeWriteSettingsKey value: $HelpMeWriteSettingsValue"

        } else {
            Log-Message -message "$HelpMeWriteSettingsKey properly configued. No changes needed"
        }
    } Catch {
        Log-Message -message "The property does not exist or an error occurred: $_"
        New-ItemProperty -Path $GoogleChromeRegPath -Name $HelpMeWriteSettingsKey -Value $HelpMeWriteSettingsValue -PropertyType DWORD -Force | Out-Null
        Log-Message -message "Set $HelpMeWriteSettingsKey value: $HelpMeWriteSettingsValue"
    }
}